import pygame, sys, os, json
from time import sleep

# class creating the puzzle for pygame
class SlidePuzzle:
    def __init__(self, gs, ts, ms):
        self.gs,self.ts,self.ms = gs, ts, ms

        self.tiles_len = gs[0]*gs[1]-1
        self.tiles = [(x,y) for y in range(gs[1]) for x in range(gs[0])] 
        #=> [(0, 0), (1, 0), (2, 0), (0, 1), (1, 1), (2, 1), (0, 2), (1, 2), (2, 2)]

        self.tilepos = {(x,y):(x*(ts+ms)+ms,y*(ts+ms)+ms) for y in range(gs[1]) for x in range(gs[0])}            
        # => {(0, 0): (0, 0), (1, 0): (5, 0), (2, 0): (10, 0), (0, 1): (0, 5), 
        # (1, 1): (5, 5), (2, 1): (10, 5), (0, 2): (0, 10), (1, 2): (5, 10), (2, 2): (10, 10)}
    
        self.rect = pygame.Rect(0,0,gs[0]*(ts+ms)+ms,gs[1]*(ts+ms)+ms)

        pic_file = "acmlogo.jpg"
        if(len(sys.argv) == 2):
            pic_file = sys.argv[1]
        pic = pygame.transform.smoothscale(pygame.image.load(pic_file),self.rect.size)


        self.images = []; font = pygame.font.Font(None, 120)
        for i in range(self.tiles_len):
            #image = pygame.Surface((ts,ts)); image.fill((150,123,14))
            x,y = self.tilepos[self.tiles[i]]
            image = pic.subsurface(x,y,ts,ts)
            text = font.render("",2,(0,0,0)); w,h = text.get_size()
            image.blit(text, ((ts-w)/2,(ts-h)/2)); self.images+=[image]

    def update(self, dt):
        pass
    
    def draw(self, screen, data_arr):
        data_arr.pop(0)
        for i in range(len(data_arr)):
            x,y = self.tilepos[self.tiles[i]]
            if(data_arr[i]!= 0):
                screen.blit(self.images[data_arr[i]-1], (x,y))

# running the visualization
def main():
    pygame.init()
    os.environ['SDL_VIDEO_CENTERED'] = '1'
    pygame.display.set_caption("Greedy A. EIght Visualization")
    screen = pygame.display.set_mode((500,500))
    fpsclock = pygame.time.Clock()
    program = SlidePuzzle((3,3),160,5)

    #load data from data file
    data_file = "data.txt"
    gen_data_file = "gen_data.txt"
    if(len(sys.argv) == 3):
        data_file = str(sys.argv[1])
        gen_data_file = str(sys.argv[2])
        
    data = json.load(open(data_file, 'r'))
    gen_data = json.load(open(gen_data_file,'r'))
    event_happened = False

    for i in gen_data:
        dt = fpsclock.tick()/1000
        screen.fill((0,0,0))
        
        program.draw(screen,data_arr=i)
        pygame.display.flip()    
        
        sleep(0.25)
        
        for event in pygame.event.get():
            if event.type == pygame.QUIT: pygame.quit(); sys.exit()

        program.update(dt)
    
        while not event_happened:
            event = pygame.event.wait()
            if event.type == pygame.MOUSEBUTTONDOWN:
                event_happened = True

        #print("infor")
    index = 0
    event_happened = False
    while True:
        dt = fpsclock.tick()/1000
        screen.fill((0,0,0))
        if(index < len(data)):
            program.draw(screen,data_arr=data[index])
            pygame.display.flip()
            index+=1      
            sleep(10/len(data))
        
        else: ## finished solving
            print(f"mixed with {len(gen_data)-1} moves\nsolved with {len(data)-1} moves")
            while event_happened:
                event = pygame.event.wait()
                if event.type == pygame.MOUSEBUTTONDOWN:
                    exit()
        
        for event in pygame.event.get():
            if event.type == pygame.QUIT: pygame.quit(); sys.exit()

        program.update(dt)

        while not event_happened: #wait for a mouse click
            event = pygame.event.wait()
            if event.type == pygame.MOUSEBUTTONDOWN:
                event_happened = True

if __name__ == "__main__":
    main()
